#include "ICMPHeader.h"
#include "ETHHeader.h"
#include <iomanip>


ICMPHeader::ICMPHeader(u_char _type, u_short _identifier, u_short _seqnumber, u_char *_data, u_short _size) 
{
  memset(&header, 0, ICMP_HEADER_SIZE);
  header.type = _type;
  header.code = 0;
  header.identifier = _identifier;
  header.sequence_number = _seqnumber;
  this->data = _data;
  this->size = _size;
  data2network();
  u_short checksum = compute_checksum();
  data2host();
  header.checksum = checksum;
}

ICMPHeader::ICMPHeader(const u_char *_data, long _size)
{	
  memcpy(&header, _data, ICMP_HEADER_SIZE);
  data = _data + ICMP_HEADER_SIZE;
  size = _size - ICMP_HEADER_SIZE;
  u_short checksum = header.checksum;
  header.checksum = 0;
  computed_checksum = compute_checksum();
  data2host();
  header.checksum = checksum;

}

void ICMPHeader::dump()
{
  cout << "ICMP Header:" << endl;
  cout << "  Type: 0x" << setbase(16) << setfill('0') << setw(4) <<  header.type << endl;
  cout << "  Code: 0x" << setw(4) << header.code << endl;
  cout << "  Checksum: 0x" << setw(4) << header.checksum << " (0x" << setw(4) << computed_checksum << " computed)" << endl;
  cout << "  Identifier: " << setbase(10) << setfill(' ') << header.identifier << endl;
  cout << "  Sequence Number: " << header.sequence_number << endl;
  cout << "  Data Size: " << size << endl;
  cout << setbase(16) << setfill('0') << "0x" << setw(2) << (int) data[0];
  for (int i = 1; i < size; i++)
    cout <<",0x" << setw(2) << (int) data[i];
  cout << endl << endl << endl;
}

u_short ICMPHeader::compute_checksum()
{
  register long sum = 0;
  int count = ICMP_HEADER_SIZE;
  u_short *addr = (u_short *) &header;

  while( count > 1 )  {
    sum += *addr++;
    count -= 2;
  }

  count = size;
  addr = (u_short *) data;

  while( count > 1 )  {
    /*  This is the inner loop */
    sum += *addr++;
    count -= 2;
  }

  if( count > 0 )
    sum += * (unsigned char *) addr;

  while (sum>>16)
    sum = (sum & 0xffff) + (sum >> 16);

  return ntohs(~sum);
}

void ICMPHeader::setMem(u_char *_data)
{
  data2network();
  memcpy(_data, &header, sizeof(header));
  memcpy(_data + ICMP_HEADER_SIZE, data, size);
}

u_char  ICMPHeader::type() const { 
  return header.type; 
}

u_char  ICMPHeader::code() const { 
  return header.code; 
}

u_short  ICMPHeader::checksum(){ 
  return header.checksum; 
}

u_short  ICMPHeader::identifier(){ 
  return header.identifier; 
}

u_short  ICMPHeader::sequence_number(){ 
  return header.sequence_number; 
}

void ICMPHeader::data2host(void) {
  header.checksum = ntohs(header.checksum);
  header.identifier = ntohs(header.identifier);
  header.sequence_number = ntohs(header.sequence_number);
}

void ICMPHeader::data2network(void) {
  header.checksum = htons(header.checksum);
  header.identifier = htons(header.identifier);
  header.sequence_number = htons(header.sequence_number);
}
